package com.ejie.ab04b.util;

/**
 * ValidadorNifCifNie
 * 
 * @author ashleypayton
 * */
public final class ValidadorNumSS {

	/**
	 * Constructor de ValidadorNifCifNie.
	 */
	private ValidadorNumSS() {
	}

	private static final int TAM_NUM_SS = 12;

	/**
	 * checkNif.
	 * 
	 *  paramString
	 *            String
	 *  boolean
	 *
	 * @param paramString the param string
	 * @return true, if successful
	 */
	public static boolean checkNSS(String paramString) {
		return paramString != null && ValidadorNumSS.isNSSValido(paramString);
	}

	/****************************************************************************************/

	private static final int POS_PROV = 2;
	private static final int POS_INI_AFILIADO = 2;
	private static final int POS_FIN_AFILIADO = 10;
	private static final int POS_INI_DIG_CONTROL = 10;
	private static final int POS_FIN_DIG_CONTROL = 12;

	private static final int DIEZ_MILLONES = 10000000;

	private static final int NUM_DIVISION_CONTROL = 97;

	/**
	 * Metodo que valida si es correcto el nss.
	 * 
	 *  nss
	 *            String
	 *  boolean
	 *
	 * @param nss the nss
	 * @return true, if is NSS valido
	 */
	public static boolean isNSSValido(String nss) {

		boolean resultado = false;
		long a;
		long b;
		long c;// digito control
		long d;
		long validacion;

		try {
			if (nss == null || "".equals(nss) || nss.length() < TAM_NUM_SS) {
				resultado = false;
			} else {
				a = Long.parseLong(nss.substring(0, POS_PROV));
				b = Long.parseLong(nss.substring(POS_INI_AFILIADO,
						POS_FIN_AFILIADO));
				c = Long.parseLong(nss.substring(POS_INI_DIG_CONTROL,
						POS_FIN_DIG_CONTROL));

				// Si el número es menor de 10 millones
				if (b < DIEZ_MILLONES) {
					// Asignamos a d la suma de b+a * 10 millones
					d = b + a * DIEZ_MILLONES;
					// Si el número es mayor de 10 millones
				} else {
					// Asignamos a d la concatenación de a y b
					d = Long.parseLong("" + a + "" + b);
				}

				// El código de validación (c),
				// debe ser el resto de la división entre 97
				validacion = d % NUM_DIVISION_CONTROL;

				// Muestra el resultado de la validación
				if (validacion == c) {
					resultado = true;
				} else {
					resultado = false;
				}
			}

		} catch (Exception e) {
			// Si ha habido algun error es porque hay algun parseo que tira
			// bien.
			resultado = false;
		}
		return resultado;
	}
}
